/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.preferences;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.debugger.IDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org2.eclipse.php.util.SWTUtil;

public class PHPDebuggersTable {
    private TableViewer fPHPDebuggers;
    private Button fSettingsButton;
    private float fWeight1 = 0.6f;
    private float fWeight2 = 0.38f;
    private boolean fResizingTable = false;

    public void createControl(Composite ancestor) {
        Composite comp = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        comp.setLayoutData((Object)data);
        final Group parent = new Group(comp, 0);
        parent.setText(PHPDebugUIMessages.PHPDebuggersTable_installedDebuggers);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        data = new GridData(1808);
        parent.setLayoutData((Object)data);
        final Table table = new Table((Composite)parent, 67586);
        data = new GridData(1808);
        data.heightHint = 35;
        table.setLayoutData((Object)data);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        final TableColumn debuggerTypeColumn = new TableColumn(table, 0);
        debuggerTypeColumn.setText(PHPDebugUIMessages.PHPDebuggersTable_debuggerType);
        final TableColumn debugPortColumn = new TableColumn(table, 0);
        debugPortColumn.setText(PHPDebugUIMessages.PHPDebuggersTable_port);
        this.fPHPDebuggers = new CheckboxTableViewer(table);
        this.fPHPDebuggers.setLabelProvider((IBaseLabelProvider)new PHPDebuggersLabelProvider());
        this.fPHPDebuggers.setContentProvider((IContentProvider)new PHPDebuggersContentProvider());
        this.fPHPDebuggers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                PHPDebuggersTable.this.enableButtons();
            }
        });
        this.fPHPDebuggers.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!PHPDebuggersTable.this.fPHPDebuggers.getSelection().isEmpty()) {
                    PHPDebuggersTable.this.editSettings();
                }
            }
        });
        final Composite buttons = new Composite((Composite)parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.fSettingsButton = this.createPushButton(buttons, PHPDebugUIMessages.PHPDebuggersTable_configure);
        this.fSettingsButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                PHPDebuggersTable.this.editSettings();
            }
        });
        this.fPHPDebuggers.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IDebuggerConfiguration && e2 instanceof IDebuggerConfiguration) {
                    return ((IDebuggerConfiguration)e2).getName().compareTo(((IDebuggerConfiguration)e1).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.configureTableResizing((Composite)parent, buttons, table, debuggerTypeColumn, debugPortColumn);
        this.fillWithWorkspaceDebuggers();
        this.enableButtons();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PHPDebuggersTable.this.resizeTable((Composite)parent, buttons, table, debuggerTypeColumn, debugPortColumn);
            }
        });
    }

    public void performDefaults() {
        AbstractDebuggerConfiguration[] debuggersConfigurations = PHPDebuggersRegistry.getDebuggersConfigurations();
        if (debuggersConfigurations == null) {
            return;
        }
        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggersConfigurations;
        int n = debuggersConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractDebuggerConfiguration conf = abstractDebuggerConfigurationArray[n2];
            conf.applyDefaults();
            ++n2;
        }
        this.fPHPDebuggers.refresh();
    }

    private void configureTableResizing(final Composite parent, final Composite buttons, final Table table, final TableColumn debuggerTypeColumn, final TableColumn debugPortColumn) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PHPDebuggersTable.this.resizeTable(parent, buttons, table, debuggerTypeColumn, debugPortColumn);
            }
        });
        table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(9, (Listener)this);
                PHPDebuggersTable.this.resizeTable(parent, buttons, table, debuggerTypeColumn, debugPortColumn);
            }
        });
        debuggerTypeColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (debuggerTypeColumn.getWidth() > 0 && !PHPDebuggersTable.this.fResizingTable) {
                    PHPDebuggersTable.this.fWeight1 = PHPDebuggersTable.this.getColumnWeight(0);
                }
            }
        });
        debugPortColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (debugPortColumn.getWidth() > 0 && !PHPDebuggersTable.this.fResizingTable) {
                    PHPDebuggersTable.this.fWeight2 = PHPDebuggersTable.this.getColumnWeight(1);
                }
            }
        });
    }

    private void resizeTable(Composite parent, Composite buttons, Table table, TableColumn column1, TableColumn column2) {
        this.fResizingTable = true;
        int parentWidth = -1;
        int parentHeight = -1;
        if (parent.isVisible()) {
            Rectangle area = parent.getClientArea();
            parentWidth = area.width;
            parentHeight = area.height;
        } else {
            Point parentSize = parent.computeSize(-1, -1);
            parentWidth = parentSize.x;
            parentHeight = parentSize.y;
        }
        Point preferredSize = table.computeSize(-1, -1);
        int width = parentWidth - 2 * table.getBorderWidth();
        if (preferredSize.y > parentHeight) {
            Point vBarSize = table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = table.getSize();
        if (oldSize.x > (width -= buttons.getSize().x)) {
            column1.setWidth(Math.round((float)width * this.fWeight1));
            column2.setWidth(Math.round((float)width * this.fWeight2));
            table.setSize(width, parentHeight);
        } else {
            table.setSize(width, parentHeight);
            column1.setWidth(Math.round((float)width * this.fWeight1));
            column2.setWidth(Math.round((float)width * this.fWeight2));
        }
        this.fResizingTable = false;
    }

    private float getColumnWeight(int col) {
        Table table;
        int tableWidth = table.getSize().x;
        table = this.fPHPDebuggers.getTable();
        int columnWidth = table.getColumn(col).getWidth();
        if (tableWidth > columnWidth) {
            return (float)columnWidth / (float)tableWidth;
        }
        switch (col) {
            case 0: {
                return 0.6f;
            }
            case 1: {
                return 0.38f;
            }
        }
        return 0.38f;
    }

    private void fillWithWorkspaceDebuggers() {
        AbstractDebuggerConfiguration[] debuggersConfigurations = PHPDebuggersRegistry.getDebuggersConfigurations();
        this.fPHPDebuggers.setInput((Object)debuggersConfigurations);
        this.fPHPDebuggers.refresh();
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPDebuggers.getSelection();
        this.fSettingsButton.setEnabled(selection.size() == 1);
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    private void editSettings() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPDebuggers.getSelection();
        AbstractDebuggerConfiguration phpDebuggerConfiguration = (AbstractDebuggerConfiguration)selection.getFirstElement();
        if (phpDebuggerConfiguration == null) {
            return;
        }
        phpDebuggerConfiguration.openConfigurationDialog(Display.getDefault().getActiveShell());
        this.fPHPDebuggers.refresh((Object)phpDebuggerConfiguration);
        this.commitChanges();
    }

    protected void commitChanges() {
    }

    class PHPDebuggersContentProvider
    implements IStructuredContentProvider {
        PHPDebuggersContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object input) {
            return PHPDebuggersRegistry.getDebuggersConfigurations();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class PHPDebuggersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PHPDebuggersLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IDebuggerConfiguration) {
                IDebuggerConfiguration configuration = (IDebuggerConfiguration)element;
                switch (columnIndex) {
                    case 0: {
                        return configuration.getName();
                    }
                    case 1: {
                        int port = configuration.getPort();
                        if (port < 0) {
                            return PHPDebugUIMessages.PHPDebuggersTable_notDefined;
                        }
                        return String.valueOf(port);
                    }
                }
            }
            return element.toString();
        }
    }
}

